﻿namespace Code6587EN.Ch07.Controls
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Publishing;
    using Microsoft.SharePoint.Publishing.Navigation;
    using Microsoft.SharePoint.Utilities;
    using System.Collections.Generic;
    using System.Web;
    using System.Linq;
    
    /// <summary>
    /// Custom Site Map provider inheriting the PortalSiteMapProvider class to provide custom 
    /// navigation data.
    /// </summary>
    public class CustomSiteMapProvider : PortalSiteMapProvider
    {
        // A collection of links to use when providing navigation data.  This could be
        // replaced with a data provider.
        private Dictionary<string, string> links = new Dictionary<string, string>() { 
                    { "Bing", "http://www.bing.com" },
                    { "Google", "http://www.google.com" },
                    { "Yahoo", "http://www.yahoo.com" }
                };

        // Include the SharePoint configured navigation in the returned navigation data?
        private bool renderSharePointLinks = false;

        // Override the GetChildNodes method to return navigation data when called.
        public override SiteMapNodeCollection GetChildNodes(SiteMapNode node)
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.CustomSiteMapProvider::GetChildNodes"))
            {
                // Instantiate the new node collection to return
                var nodes = new SiteMapNodeCollection();

                // Attempt to cast the provided node as a PortalSiteMapNode
                PortalSiteMapNode portalNode = node as PortalSiteMapNode;
                if (portalNode != null)
                {
                    // Check the note type to ensure it is for the current site
                    // http://msdn.microsoft.com/en-us/library/sharepoint/microsoft.sharepoint.publishing.nodetypes.aspx
                    if (portalNode.Type == NodeTypes.Area && portalNode.WebId == SPContext.Current.Site.RootWeb.ID)
                    {
                        // Add new site map nodes from the links list
                        foreach (var link in links)
                            nodes.Add(new SiteMapNode(this, link.Key, link.Value, link.Key));
                    }

                    // If including SharePoint configured links, get them from the base class
                    // and add them to the node collection (if having the links render before the 
                    // custom links, move this before the preceeding foreach loop)
                    if (renderSharePointLinks)
                        nodes.AddRange(base.GetChildNodes(portalNode));
                }

                // Return the nodes collection
                return nodes;
            }
        }
    }
}
